/************************************************************************/
/*                                                                      */
/* Borland Enterprise Core Objects                                      */
/*                                                                      */
/* Copyright (c) 2003-2005 Borland Software Corporation                 */
/*                                                                      */
/************************************************************************/

using System;
using System.Drawing; // For ToolboxBitmap
using System.Collections.Specialized;
using Borland.Eco.ObjectRepresentation;
using Borland.Eco.UmlRt;
using Borland.Eco.Services;
using Borland.Eco.Handles;

namespace Borland.Eco.Handles
{
	/// <summary>
	/// Owns a value not part of the eco space.
	/// </summary>
	[ToolboxBitmap(typeof(VariableHandle), "Borland.Eco.Handles.VariableHandle.bmp")]
	public sealed class VariableHandle: RootHandle
	{
		
		private void EnsureVariable()
		{   // Create Variable
			IVariableFactoryService vs = (IVariableFactoryService)GetEcoService(typeof(IVariableFactoryService));
			IClassifier staticType = GetStaticUmlType();
			if ((vs == null) || (staticType == null))
				InternalElement = null;
			else if ((InternalElement == null) || !(InternalElement as IVariable).StaticUmlType.IsSame(staticType))
			{
				InternalElement = vs.CreateVariable(staticType);
			}
		}

		protected override void StaticContextChanged()
		{   // Create Variable
			EnsureVariable();
			base.StaticContextChanged();
		}

		protected override void EnsureInternalElement()
		{
            EnsureVariable();
		}

		protected override void ActiveChanged()
		{
			if (Active)
				EnsureVariable();
			else
				InternalElement = null;
			base.ActiveChanged();
		}
	}
}
